/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.DataLabelTable;
import cds.aladin.TapFrameServer;
import cds.mocmulti.MocItem2;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.TableModelEvent;

public class MocDataLabelTable
extends DataLabelTable {
    List<String> dataLabels;

    public MocDataLabelTable() {
    }

    public MocDataLabelTable(Aladin aladin, List<String> dataLabels) {
        super(aladin);
        this.dataLabels = dataLabels;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.dataLabels != null) {
            result = this.dataLabels.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MocItem2 mi = this.aladin.directory.multiProp.getItem(this.dataLabels.get(rowIndex));
        switch (columnIndex) {
            case 0: {
                return this.dataLabels.get(rowIndex);
            }
            case 1: {
                String desc = mi.prop.get("obs_title");
                if (desc == null) {
                    desc = mi.prop.get("obs_collection");
                }
                return desc;
            }
            case 2: {
                return mi.prop.get("tap_service_url");
            }
        }
        return "";
    }

    @Override
    public Vector<String> getDataLabelAt(int rowIndex) {
        Vector<String> result = null;
        MocItem2 mi = this.aladin.directory.multiProp.getItem(this.dataLabels.get(rowIndex));
        String desc = mi.prop.get("obs_title");
        if (desc == null) {
            desc = mi.prop.get("obs_collection");
        }
        result = new Vector<String>();
        result.add(TapFrameServer.labelId, this.dataLabels.get(rowIndex));
        result.add(TapFrameServer.descriptionId, desc);
        result.add(TapFrameServer.urlId, mi.prop.get("tap_service_url"));
        return result;
    }

    @Override
    public void defaultSortServers() {
        Collections.sort(this.dataLabels, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int n = o1.compareTo(o2);
                if (n != 0) {
                    return n;
                }
                MocItem2 mi1 = MocDataLabelTable.this.aladin.directory.multiProp.getItem(o1);
                MocItem2 mi2 = MocDataLabelTable.this.aladin.directory.multiProp.getItem(o2);
                return mi1.prop.get("tap_service_url").compareTo(mi2.prop.get("tap_service_url"));
            }
        });
        if (!this.ascSort) {
            Collections.reverse(this.dataLabels);
        }
        this.ascSort = !this.ascSort;
    }

    @Override
    public void notifyTableChanged() {
        int n = this.dataLabels.size();
        if (this.tableListener != null) {
            this.tableListener.tableChanged(new TableModelEvent(this, n, n, -1, 1));
        }
    }
}

